"""
HB_Rotate V1.1

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_Rotate
Description-US: Rotate Tool Setup [SHIFT: Enable Quantizing, CTRL: Enable along Normal Mode]]

This Script does following things:
- Enables the Rotate Tool
- Show Axis if hidden
- Disable Quantize Snapping if enabled

- Shift-Click: Enable Quantize Snapping and set it to 45 Degree for Rotation

Video Tutorial:
https://youtu.be/eEcAttV56kE?t=21m
https://youtu.be/UlY-X5O137M?t=594

Name-DE: HB_Rotate
Description-DE: Rotieren Tool [SHIFT: Aktiviere Quantize]

ChangeLog:

Jun/11/2015 V1.0
- Release Version

Oct/11/2018 V1.1
- New Highres Icon

"""
import c4d, math
from c4d.modules import snap
from c4d import documents, plugins


def tool():
    return plugins.FindPlugin(doc.GetAction(), c4d.PLUGINTYPE_TOOL)

def main():

    bc = c4d.BaseContainer()
    if c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc):
        c4d.CallCommand(200000090) # Rotate
        if bc[c4d.BFM_INPUT_QUALIFIER] ==0 :

            tool()[c4d.MDATA_AXIS_ROT]=0 #AXIS mode
            tool()[c4d.MDATA_AXIS_NORMAL_PSR]=False

            if (snap.IsQuantizeEnabled(doc)):
                c4d.CallCommand(c4d.QUANTIZE_ENABLED)

            snap.SetQuantizeStep(doc, None, c4d.QUANTIZE_ROTATE,c4d.utils.Rad(5))
            if not (c4d.IsCommandChecked(1016176)):
                c4d.CallCommand(1016176) # Show Axis

        if bc[c4d.BFM_INPUT_QUALIFIER] ==1 : # Shift-Click

            if not (snap.IsQuantizeEnabled(doc)):
                # Enable quantizing if not activated
                c4d.CallCommand(c4d.QUANTIZE_ENABLED)

            if not (c4d.IsCommandChecked(1016176)):
                c4d.CallCommand(1016176) # Show Axis

            snap.SetQuantizeStep(doc, None, c4d.QUANTIZE_ROTATE,c4d.utils.Rad(45))


        if bc[c4d.BFM_INPUT_QUALIFIER] ==2 : # CTRL
            
            tool()[c4d.MDATA_AXIS_ROT]=5 #AXIS mode
            tool()[c4d.MDATA_AXIS_NORMAL_PSR]=True


if __name__=='__main__':
    main()
    c4d.EventAdd()